/*
 * QrfeGuiLibGlobal.h
 *
 *  Created on: 08.10.2010
 *      Author: stefan.detter
 */

#ifndef QRFEGUILIBGLOBAL_H_
#define QRFEGUILIBGLOBAL_H_

#include <QObject>
#include <QColor>

#include <QrfeGlobal>

class QStandardItemModel;
class QWidget;
class QFile;

namespace QrfeGlobal
{
	Q_ENUMS(ProgressBarMode)
	typedef enum {
		STATIC,
		FLOATING,
	} ProgressBarMode;

	Q_ENUMS(BeepMode)
	typedef enum {
		BEEP_INTERNAL,
		BEEP_SPEAKER,
		BEEP_BOTH,
		BEEP_OFF
	}BeepMode;

	bool 	saveBytesToFile(const QByteArray& data, QWidget * parent, const QString & caption, const QString & dir, QString & outputFileName);

	bool	saveStandardModelToFile ( QStandardItemModel* model, QWidget * parent, const QString & caption, const QString & dir, QString & outputFileName );
	bool 	saveStandardModelToFile(QStandardItemModel* model, QFile* file);
	bool 	saveStandardModelToFile(QStandardItemModel* model, int fromRow, int count, QFile* file);

	void 	centerWidgetOnScreen ( QWidget * widget );

	QColor 	getAlternatingDarkColors(int colorIndex);
	QColor 	getAlternatingRowColors(int colorIndex, int rowIndex);

	void 	beep ( QrfeGlobal::BeepMode mode );
};

class __init_QrfeGuiLibGlobal
{
public:
	__init_QrfeGuiLibGlobal();
};

#endif /* QRFEGUILIBGLOBAL_H_ */
